/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import org.w3c.dom.Node;
import pse.assessment.AnswerNetwork;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.assessment.InitialNetwork;
import pse.common.FileInfo;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class TaskMetaData
extends AssessmentObject {
    protected AnswerNetwork answerNetwork;
    protected FileInfo fileInfo;
    protected InitialNetwork initialNetwork;
    protected String marvelTimestamp;
    protected String marvelVersion;
    protected String maxId;
    protected String overallSummary;
    protected String pkaTimestamp;
    protected String pseVersion;
    protected String ptVersion;

    public boolean isTaskObject() {
        return true;
    }

    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        String string;
        if (this.fileInfo != null && (string = this.fileInfo.getFileName()) != null) {
            boolean bl;
            boolean bl2 = consistencyChecker.hasFile(string);
            boolean bl3 = bl = this.fileInfo.getContents() != null;
            if (!bl2 && !bl) {
                consistencyChecker.missingFile(this, string);
            }
        }
        if (this.answerNetwork != null) {
            this.answerNetwork.checkForConsistency(consistencyChecker);
        }
        if (this.initialNetwork != null) {
            this.initialNetwork.checkForConsistency(consistencyChecker);
        }
    }

    public String getElementName() {
        return "task-metadata";
    }

    public boolean hasAttributes() {
        return true;
    }

    public boolean hasChildren() {
        return super.hasChildren() || this.answerNetwork != null || this.fileInfo != null || this.initialNetwork != null || this.nonEmptyString(this.overallSummary);
    }

    public AnswerNetwork getAnswerNetwork() {
        return this.answerNetwork;
    }

    public void setAnswerNetwork(AnswerNetwork answerNetwork) {
        this.answerNetwork = answerNetwork;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public InitialNetwork getInitialNetwork() {
        return this.initialNetwork;
    }

    public void setInitialNetwork(InitialNetwork initialNetwork) {
        this.initialNetwork = initialNetwork;
    }

    public String getMarvelTimestamp() {
        return this.marvelTimestamp;
    }

    public void setMarvelTimestamp(String string) {
        this.marvelTimestamp = string;
    }

    public String getMarvelVersion() {
        return this.marvelVersion;
    }

    public void setMarvelVersion(String string) {
        this.marvelVersion = string;
    }

    public String getMaxId() {
        return this.maxId;
    }

    public void setMaxId(String string) {
        this.maxId = string;
    }

    public String getOverallSummary() {
        return this.overallSummary;
    }

    public void setOverallSummary(String string) {
        this.overallSummary = string;
    }

    public String getPkaTimestamp() {
        return this.pkaTimestamp;
    }

    public void setPkaTimestamp(String string) {
        this.pkaTimestamp = string;
    }

    public String getPseVersion() {
        return this.pseVersion;
    }

    public void setPseVersion(String string) {
        this.pseVersion = string;
    }

    public String getPtVersion() {
        return this.ptVersion;
    }

    public void setPtVersion(String string) {
        this.ptVersion = string;
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("marvel-version", this.marvelVersion);
        xmlWriter.addAttribute("marvel-timestamp", this.marvelTimestamp);
        xmlWriter.addAttribute("pt-version", this.ptVersion);
        xmlWriter.addAttribute("pka-timestamp", this.pkaTimestamp);
        xmlWriter.addAttribute("pse-version", this.pseVersion);
        xmlWriter.addNullableAttribute("max-id", this.maxId);
    }

    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.addCDataElement("overall-summary", this.overallSummary);
        xmlWriter.openElement("pka-info");
        this.addChild(xmlWriter, this.fileInfo);
        this.addChild(xmlWriter, this.initialNetwork);
        this.addChild(xmlWriter, this.answerNetwork);
        xmlWriter.closeElement();
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.marvelVersion = XmlUtils.getAttribute(node, "marvel-version");
        this.marvelTimestamp = XmlUtils.getAttribute(node, "marvel-timestamp");
        this.ptVersion = XmlUtils.getAttribute(node, "pt-version");
        this.pkaTimestamp = XmlUtils.getAttribute(node, "pka-timestamp");
        this.pseVersion = XmlUtils.getAttribute(node, "pse-version");
        this.maxId = XmlUtils.getAttribute(node, "max-id");
    }

    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        this.overallSummary = XmlUtils.getChildText(node, "overall-summary");
        Node node2 = XmlUtils.getChild(node, "pka-info");
        this.fileInfo = (FileInfo)this.readChild(node2, new FileInfo());
        this.initialNetwork = (InitialNetwork)this.readChild(node2, new InitialNetwork());
        this.answerNetwork = (AnswerNetwork)this.readChild(node2, new AnswerNetwork());
    }
}

